/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.SubscriptObjectFunction;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class SubscriptFunction
extends Scalar<Object, Object[]> {
    public static final String NAME = "subscript";
    private final Signature signature;
    private final Signature boundSignature;
    private final BiFunction<Object, Object, Object> lookup;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("array(object)"), DataTypes.STRING.getTypeSignature(), TypeSignature.parseTypeSignature("array(undefined)")).withForbiddenCoercion(), (signature, boundSignature) -> new SubscriptFunction((Signature)signature, (Signature)boundSignature, SubscriptFunction::lookupIntoListObjectsByName));
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("array(E)"), DataTypes.INTEGER.getTypeSignature(), TypeSignature.parseTypeSignature("E")).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), (signature, boundSignature) -> new SubscriptFunction((Signature)signature, (Signature)boundSignature, SubscriptFunction::lookupByNumericIndex));
        module.register(Signature.scalar(NAME, DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.UNDEFINED.getTypeSignature()).withForbiddenCoercion(), (signature, boundSignature) -> new SubscriptFunction((Signature)signature, (Signature)boundSignature, SubscriptFunction::lookupByName));
        module.register(Signature.scalar(NAME, DataTypes.UNDEFINED.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.UNDEFINED.getTypeSignature()).withForbiddenCoercion(), (signature, boundSignature) -> new SubscriptFunction((Signature)signature, (Signature)boundSignature, SubscriptFunction::lookupByName));
    }

    private SubscriptFunction(Signature signature, Signature boundSignature, BiFunction<Object, Object, Object> lookup) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.lookup = lookup;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function func, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol result = SubscriptFunction.evaluateIfLiterals(this, txnCtx, nodeCtx, func);
        if (result instanceof Literal) {
            return result;
        }
        if (func.arguments().get(0).valueType().id() == 12) {
            return SubscriptObjectFunction.tryToInferReturnTypeFromObjectTypeAndArguments(func);
        }
        return func;
    }

    @Override
    public Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        assert (args.length == 2) : "invalid number of arguments";
        Object element = args[0].value();
        Object index = args[1].value();
        if (element == null || index == null) {
            return null;
        }
        return this.lookup.apply(element, index);
    }

    static Object lookupIntoListObjectsByName(Object base, Object name) {
        List values = (List)base;
        ArrayList result = new ArrayList(values.size());
        for (int i = 0; i < values.size(); ++i) {
            Map map = (Map)values.get(i);
            result.add(map.get(name));
        }
        return result;
    }

    static Object lookupByNumericIndex(Object base, Object index) {
        List values = (List)base;
        int idx = ((Number)index).intValue();
        try {
            return values.get(idx - 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    static Object lookupByName(Object base, Object name) {
        if (!(base instanceof Map)) {
            throw new IllegalArgumentException("Base argument to subscript must be an object, not " + base);
        }
        Map map = (Map)base;
        if (!map.containsKey(name)) {
            throw new IllegalArgumentException("The object `" + base + "` does not contain the key `" + name + "`");
        }
        return map.get(name);
    }
}

