/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.Locale;

public class FormatFunction
extends Scalar<String, Object> {
    public static final String NAME = "format";
    public static final Signature SIGNATURE = Signature.scalar("format", DataTypes.STRING.getTypeSignature(), TypeSignature.parseTypeSignature("E"), DataTypes.STRING.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariableOfAnyType("E")).withVariableArity();
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(SIGNATURE, FormatFunction::new);
    }

    public FormatFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    @SafeVarargs
    public final String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length > 1) : "number of args must be > 1";
        Object arg0Value = args[0].value();
        assert (arg0Value != null) : "1st argument must not be null";
        Object[] values = new Object[args.length - 1];
        for (int i = 0; i < args.length - 1; ++i) {
            Object value;
            values[i] = value = args[i + 1].value();
        }
        return String.format(Locale.ENGLISH, (String)arg0Value, values);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }
}

