/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.Extract;
import io.crate.types.DataTypes;
import io.crate.types.TimestampType;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.joda.Joda;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;

public class ExtractFunctions {
    public static final String NAME_PREFIX = "extract_";
    private static final Map<Extract.Field, DateTimeField> FIELDS_MAP_WITH_INT_RETURN = Map.ofEntries(Map.entry(Extract.Field.CENTURY, ISOChronology.getInstanceUTC().centuryOfEra()), Map.entry(Extract.Field.YEAR, ISOChronology.getInstanceUTC().year()), Map.entry(Extract.Field.QUARTER, Joda.QUARTER_OF_YEAR.getField((Chronology)ISOChronology.getInstanceUTC())), Map.entry(Extract.Field.MONTH, ISOChronology.getInstanceUTC().monthOfYear()), Map.entry(Extract.Field.WEEK, ISOChronology.getInstanceUTC().weekOfWeekyear()), Map.entry(Extract.Field.DAY_OF_MONTH, ISOChronology.getInstanceUTC().dayOfMonth()), Map.entry(Extract.Field.DAY_OF_WEEK, ISOChronology.getInstanceUTC().dayOfWeek()), Map.entry(Extract.Field.DAY_OF_YEAR, ISOChronology.getInstanceUTC().dayOfYear()), Map.entry(Extract.Field.HOUR, ISOChronology.getInstanceUTC().hourOfDay()), Map.entry(Extract.Field.MINUTE, ISOChronology.getInstanceUTC().minuteOfHour()), Map.entry(Extract.Field.SECOND, ISOChronology.getInstanceUTC().secondOfMinute()));

    public static void register(ScalarFunctionModule module) {
        for (TimestampType argType : List.of(DataTypes.TIMESTAMPZ, DataTypes.TIMESTAMP)) {
            for (Map.Entry<Extract.Field, DateTimeField> entry : FIELDS_MAP_WITH_INT_RETURN.entrySet()) {
                module.register(Signature.scalar(ExtractFunctions.functionNameFrom(entry.getKey()), argType.getTypeSignature(), TypeSignature.parseTypeSignature("integer")), (signature, boundSignature) -> new ExtractFunction((Signature)signature, (Signature)boundSignature, l -> ((DateTimeField)entry.getValue()).get(l.longValue())));
            }
            module.register(Signature.scalar(ExtractFunctions.functionNameFrom(Extract.Field.EPOCH), argType.getTypeSignature(), TypeSignature.parseTypeSignature("double precision")), (signature, boundSignature) -> new ExtractFunction((Signature)signature, (Signature)boundSignature, v -> (double)v.longValue() / 1000.0));
        }
    }

    public static String functionNameFrom(Extract.Field field) {
        switch (field) {
            case CENTURY: 
            case YEAR: 
            case QUARTER: 
            case MONTH: 
            case WEEK: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case EPOCH: {
                return NAME_PREFIX + field.toString();
            }
            case DAY_OF_MONTH: 
            case DAY: {
                return NAME_PREFIX + Extract.Field.DAY_OF_MONTH.toString();
            }
            case DAY_OF_WEEK: 
            case DOW: {
                return NAME_PREFIX + Extract.Field.DAY_OF_WEEK.toString();
            }
            case DAY_OF_YEAR: 
            case DOY: {
                return NAME_PREFIX + Extract.Field.DAY_OF_YEAR.toString();
            }
        }
        throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Extract( %s from <expression>) is not supported", new Object[]{field}));
    }

    private static class ExtractFunction
    extends Scalar<Number, Long> {
        private final Signature signature;
        private final Signature boundSignature;
        private final Function<Long, Number> evaluate;

        ExtractFunction(Signature signature, Signature boundSignature, Function<Long, Number> evaluate) {
            this.signature = signature;
            this.boundSignature = boundSignature;
            this.evaluate = evaluate;
        }

        @Override
        public Signature signature() {
            return this.signature;
        }

        @Override
        public Signature boundSignature() {
            return this.boundSignature;
        }

        public Number evaluate(long value) {
            return this.evaluate.apply(value);
        }

        @Override
        @SafeVarargs
        public final Number evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Long> ... args) {
            assert (args.length == 1) : "extract only takes one argument";
            Long value = args[0].value();
            if (value == null) {
                return null;
            }
            return this.evaluate(value);
        }
    }
}

