/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import java.util.function.DoubleUnaryOperator;

public final class DoubleScalar
extends Scalar<Double, Number> {
    private final Signature signature;
    private final Signature boundSignature;
    private final DoubleUnaryOperator func;

    public DoubleScalar(Signature signature, Signature boundSignature, DoubleUnaryOperator func) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.func = func;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @SafeVarargs
    public final Double evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Number> ... args) {
        assert (args.length == 1) : "DoubleScalar expects exactly 1 argument, got: " + args.length;
        Number value = args[0].value();
        if (value == null) {
            return null;
        }
        return this.func.applyAsDouble(value.doubleValue());
    }
}

