/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.TimeZoneParser;
import io.crate.expression.scalar.TimestampFormatter;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.LongType;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateFormatFunction
extends Scalar<String, Object> {
    public static final String NAME = "date_format";
    public static final String DEFAULT_FORMAT = "%Y-%m-%dT%H:%i:%s.%fZ";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        List<LongType> supportedTimestampTypes = List.of(DataTypes.TIMESTAMPZ, DataTypes.TIMESTAMP, DataTypes.LONG);
        for (DataType dataType : supportedTimestampTypes) {
            module.register(Signature.scalar(NAME, dataType.getTypeSignature(), DataTypes.STRING.getTypeSignature()), DateFormatFunction::new);
            module.register(Signature.scalar(NAME, DataTypes.STRING.getTypeSignature(), dataType.getTypeSignature(), DataTypes.STRING.getTypeSignature()), DateFormatFunction::new);
            module.register(Signature.scalar(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), dataType.getTypeSignature(), DataTypes.STRING.getTypeSignature()), DateFormatFunction::new);
        }
    }

    public DateFormatFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        String format;
        Input<Object> timezoneLiteral = null;
        if (args.length == 1) {
            format = DEFAULT_FORMAT;
        } else {
            format = (String)args[0].value();
            if (format == null) {
                return null;
            }
            if (args.length == 3) {
                timezoneLiteral = args[1];
            }
        }
        Object tsValue = args[args.length - 1].value();
        if (tsValue == null) {
            return null;
        }
        Long timestamp = DataTypes.TIMESTAMPZ.sanitizeValue(tsValue);
        DateTimeZone timezone = DateTimeZone.UTC;
        if (timezoneLiteral != null) {
            Object timezoneValue = timezoneLiteral.value();
            if (timezoneValue == null) {
                return null;
            }
            timezone = TimeZoneParser.parseTimeZone((String)timezoneValue);
        }
        DateTime dateTime = new DateTime((Object)timestamp, timezone);
        return TimestampFormatter.format(format, dateTime);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }
}

