/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ArrayCatFunction;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;

public abstract class ConcatFunction
extends Scalar<String, String> {
    public static final String NAME = "concat";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), StringConcatFunction::new);
        module.register(Signature.scalar(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).withVariableArity(), GenericConcatFunction::new);
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("array(E)")).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), ArrayCatFunction::new);
    }

    ConcatFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function function, TransactionContext txnCtx, NodeContext nodeCtx) {
        if (ConcatFunction.anyNonLiterals(function.arguments())) {
            return function;
        }
        Input[] inputs = new Input[function.arguments().size()];
        for (int i = 0; i < function.arguments().size(); ++i) {
            inputs[i] = (Input)((Object)function.arguments().get(i));
        }
        return Literal.ofUnchecked(this.boundSignature.getReturnType().createType(), this.evaluate(txnCtx, nodeCtx, inputs));
    }

    private static class GenericConcatFunction
    extends ConcatFunction {
        public GenericConcatFunction(Signature signature, Signature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                String value = args[i].value();
                if (value == null) continue;
                sb.append(value);
            }
            return sb.toString();
        }
    }

    static class StringConcatFunction
    extends ConcatFunction {
        StringConcatFunction(Signature signature, Signature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
            String firstArg = (String)args[0].value();
            String secondArg = (String)args[1].value();
            if (firstArg == null) {
                if (secondArg == null) {
                    return "";
                }
                return secondArg;
            }
            if (secondArg == null) {
                return firstArg;
            }
            return firstArg + secondArg;
        }
    }
}

