/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;

public class CollectionAverageFunction
extends Scalar<Double, List<Object>> {
    public static final String NAME = "collection_avg";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("array(E)"), DataTypes.DOUBLE.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), CollectionAverageFunction::new);
    }

    private CollectionAverageFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Double evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>> ... args) {
        List<Object> values = args[0].value();
        if (values == null) {
            return null;
        }
        double sum = 0.0;
        long count = 0L;
        for (Object value : values) {
            sum += ((Number)value).doubleValue();
            ++count;
        }
        if (count > 0L) {
            return sum / (double)count;
        }
        return null;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }
}

