/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class ArrayUniqueFunction
extends Scalar<List<Object>, List<Object>> {
    public static final String NAME = "array_unique";
    private final Signature signature;
    private final Signature boundSignature;
    private final DataType<?> elementType;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("array(E)")).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), ArrayUniqueFunction::new);
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("array(E)")).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), ArrayUniqueFunction::new);
    }

    private ArrayUniqueFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.elementType = ((ArrayType)boundSignature.getReturnType().createType()).innerType();
        List<DataType<?>> argumentTypes = boundSignature.getArgumentDataTypes();
        if (argumentTypes.size() == 1) {
            ArrayArgumentValidators.ensureSingleArgumentArrayInnerTypeIsNotUndefined(argumentTypes);
        } else {
            ArrayArgumentValidators.ensureBothInnerTypesAreNotUndefined(boundSignature.getArgumentDataTypes(), NAME);
        }
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        HashSet uniqueSet = new HashSet();
        ArrayList<Object> uniqueItems = new ArrayList<Object>();
        for (Input array : args) {
            assert (array != null) : "inputs must never be null";
            List values = (List)array.value();
            if (values == null) continue;
            for (Object element : values) {
                Object value = this.elementType.sanitizeValue(element);
                if (!uniqueSet.add(value)) continue;
                uniqueItems.add(value);
            }
        }
        return uniqueItems;
    }
}

