/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;

class ArrayLowerFunction
extends Scalar<Integer, Object> {
    public static final String NAME = "array_lower";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("array(E)"), DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), ArrayLowerFunction::new);
    }

    public ArrayLowerFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        ArrayArgumentValidators.ensureInnerTypeIsNotUndefined(boundSignature.getArgumentDataTypes(), NAME);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Integer evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        List values = (List)args[0].value();
        Object dimension1Indexed = args[1].value();
        if (values == null || values.isEmpty() || dimension1Indexed == null) {
            return null;
        }
        int dimension = (Integer)dimension1Indexed - 1;
        try {
            Object dimensionValue = values.get(dimension);
            if (dimensionValue instanceof List) {
                List dimensionArray = (List)dimensionValue;
                return dimensionArray.size() > 0 ? Integer.valueOf(1) : null;
            }
            return 1;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}

