/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

class ArrayDifferenceFunction
extends Scalar<List<Object>, List<Object>> {
    public static final String NAME = "array_difference";
    private final Signature signature;
    private final Signature boundSignature;
    private final Optional<Set<Object>> optionalSubtractSet;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("array(E)")).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), (signature, boundSignature) -> new ArrayDifferenceFunction((Signature)signature, (Signature)boundSignature, null));
    }

    private ArrayDifferenceFunction(Signature signature, Signature boundSignature, @Nullable Set<Object> subtractSet) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.optionalSubtractSet = Optional.ofNullable(subtractSet);
        ArrayArgumentValidators.ensureBothInnerTypesAreNotUndefined(boundSignature.getArgumentDataTypes(), NAME);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Scalar<List<Object>, List<Object>> compile(List<Symbol> arguments) {
        Set<Object> subtractSet;
        Symbol symbol = arguments.get(1);
        if (!symbol.symbolType().isValueSymbol()) {
            return this;
        }
        Input input = (Input)((Object)symbol);
        Object inputValue = input.value();
        DataType innerType = ((ArrayType)this.boundSignature.getReturnType().createType()).innerType();
        List values = (List)inputValue;
        if (values == null) {
            subtractSet = Collections.emptySet();
        } else {
            subtractSet = new HashSet();
            for (Object element : values) {
                subtractSet.add(innerType.sanitizeValue(element));
            }
        }
        return new ArrayDifferenceFunction(this.signature, this.boundSignature, subtractSet);
    }

    @Override
    public List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        Set<Object> localSubtractSet;
        List inputValues = (List)args[0].value();
        if (inputValues == null) {
            return null;
        }
        DataType innerType = ((ArrayType)this.boundSignature.getReturnType().createType()).innerType();
        if (this.optionalSubtractSet.isEmpty()) {
            localSubtractSet = new HashSet();
            for (int i = 1; i < args.length; ++i) {
                Object argValue = args[i].value();
                if (argValue == null) continue;
                List values = (List)argValue;
                for (Object element : values) {
                    localSubtractSet.add(innerType.sanitizeValue(element));
                }
            }
        } else {
            localSubtractSet = this.optionalSubtractSet.get();
        }
        ArrayList<Object> resultList = new ArrayList<Object>(inputValues.size());
        for (Object value : inputValues) {
            if (localSubtractSet.contains(innerType.sanitizeValue(value))) continue;
            resultList.add(value);
        }
        return resultList;
    }
}

