/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;

class ArrayCatFunction
extends Scalar<List<Object>, List<Object>> {
    public static final String NAME = "array_cat";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("array(E)"), TypeSignature.parseTypeSignature("array(E)")).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), ArrayCatFunction::new);
    }

    ArrayCatFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        ArrayArgumentValidators.ensureBothInnerTypesAreNotUndefined(boundSignature.getArgumentDataTypes(), signature.getName().name());
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @SafeVarargs
    public final List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>> ... args) {
        DataType innerType = ((ArrayType)this.boundSignature.getReturnType().createType()).innerType();
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Input<List<Object>> arg : args) {
            List<Object> values = arg.value();
            if (values == null) continue;
            for (Object value : values) {
                resultList.add(innerType.sanitizeValue(value));
            }
        }
        return resultList;
    }
}

