/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.snapshot;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.expression.reference.sys.snapshot.SysSnapshot;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;

@Singleton
public class SysSnapshots {
    private static final Logger LOGGER = LogManager.getLogger(SysSnapshots.class);
    private final Supplier<Collection<Repository>> getRepositories;

    @Inject
    public SysSnapshots(RepositoriesService repositoriesService) {
        this(repositoriesService::getRepositoriesList);
    }

    @VisibleForTesting
    SysSnapshots(Supplier<Collection<Repository>> getRepositories) {
        this.getRepositories = getRepositories;
    }

    public Iterable<SysSnapshot> currentSnapshots() {
        return () -> this.getRepositories.get().stream().flatMap(repository -> repository.getRepositoryData().getSnapshotIds().stream().map(snapshotId -> SysSnapshots.createSysSnapshot(repository, snapshotId))).iterator();
    }

    private static SysSnapshot createSysSnapshot(Repository repository, SnapshotId snapshotId) {
        SnapshotInfo snapshotInfo;
        try {
            snapshotInfo = repository.getSnapshotInfo(snapshotId);
        }
        catch (SnapshotException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Couldn't retrieve snapshotId={} error={}", (Object)snapshotId, (Object)e);
            }
            return new SysSnapshot(snapshotId.getName(), repository.getMetadata().name(), Collections.emptyList(), null, null, null, SnapshotState.FAILED.name(), List.of());
        }
        Version version = snapshotInfo.version();
        return new SysSnapshot(snapshotId.getName(), repository.getMetadata().name(), snapshotInfo.indices(), snapshotInfo.startTime(), snapshotInfo.endTime(), version == null ? null : version.toString(), snapshotInfo.state().name(), Lists2.map(snapshotInfo.shardFailures(), SnapshotShardFailure::toString));
    }
}

