/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.shard;

import io.crate.expression.reference.sys.shard.SysAllocation;
import io.crate.metadata.IndexParts;
import java.util.Iterator;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.MoveDecision;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.gateway.GatewayAllocator;

@Singleton
public class SysAllocations
implements Iterable<SysAllocation> {
    private final ClusterService clusterService;
    private final ClusterInfoService clusterInfoService;
    private final AllocationDeciders allocationDeciders;
    private final ShardsAllocator shardAllocator;
    private final GatewayAllocator gatewayAllocator;

    @Inject
    public SysAllocations(ClusterService clusterService, ClusterInfoService clusterInfoService, AllocationDeciders allocationDeciders, ShardsAllocator shardAllocator, GatewayAllocator gatewayAllocator) {
        this.clusterService = clusterService;
        this.clusterInfoService = clusterInfoService;
        this.allocationDeciders = allocationDeciders;
        this.shardAllocator = shardAllocator;
        this.gatewayAllocator = gatewayAllocator;
    }

    @Override
    public Iterator<SysAllocation> iterator() {
        ClusterState state = this.clusterService.state();
        RoutingNodes routingNodes = state.getRoutingNodes();
        ClusterInfo clusterInfo = this.clusterInfoService.getClusterInfo();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, state, clusterInfo, System.nanoTime());
        return allocation.routingTable().allShards().stream().filter(shardRouting -> !IndexParts.isDangling(shardRouting.getIndexName())).map(shardRouting -> this.createSysAllocations(allocation, (ShardRouting)shardRouting)).iterator();
    }

    private SysAllocation createSysAllocations(RoutingAllocation allocation, ShardRouting shardRouting) {
        allocation.setDebugMode(RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS);
        Supplier<ShardAllocationDecision> shardDecision = () -> {
            AllocateUnassignedDecision allocateDecision;
            if (shardRouting.initializing() || shardRouting.relocating()) {
                return ShardAllocationDecision.NOT_TAKEN;
            }
            AllocateUnassignedDecision allocateUnassignedDecision = allocateDecision = shardRouting.unassigned() ? this.gatewayAllocator.decideUnassignedShardAllocation(shardRouting, allocation) : AllocateUnassignedDecision.NOT_TAKEN;
            if (!allocateDecision.isDecisionTaken()) {
                return this.shardAllocator.decideShardAllocation(shardRouting, allocation);
            }
            return new ShardAllocationDecision(allocateDecision, MoveDecision.NOT_TAKEN);
        };
        return new SysAllocation(shardRouting.shardId(), shardRouting.state(), shardDecision, shardRouting.currentNodeId(), shardRouting.primary());
    }
}

