/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.shard;

import com.google.common.base.Suppliers;
import io.crate.blob.v2.BlobShard;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.seqno.RetentionLease;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.indices.recovery.RecoveryState;

public class ShardRowContext {
    private final IndexShard indexShard;
    @Nullable
    private final BlobShard blobShard;
    private final ClusterService clusterService;
    private final Supplier<Long> sizeSupplier;
    private final IndexParts indexParts;
    private final String partitionIdent;
    private final int id;
    private final String path;
    @Nullable
    private final String blobPath;
    @Nullable
    private final String aliasName;
    @Nullable
    private final String templateName;

    public ShardRowContext(IndexShard indexShard, ClusterService clusterService) {
        this(indexShard, null, clusterService, (Supplier<Long>)Suppliers.memoizeWithExpiration(() -> {
            try {
                StoreStats storeStats = indexShard.storeStats();
                return storeStats.getSizeInBytes();
            }
            catch (AlreadyClosedException e) {
                return 0L;
            }
        }, (long)10L, (TimeUnit)TimeUnit.SECONDS));
    }

    public ShardRowContext(BlobShard blobShard, ClusterService clusterService) {
        this(blobShard.indexShard(), blobShard, clusterService, blobShard::getTotalSize);
    }

    private ShardRowContext(IndexShard indexShard, @Nullable BlobShard blobShard, ClusterService clusterService, Supplier<Long> sizeSupplier) {
        this.indexShard = indexShard;
        this.blobShard = blobShard;
        this.clusterService = clusterService;
        this.sizeSupplier = sizeSupplier;
        ShardId shardId = indexShard.shardId();
        String indexName = shardId.getIndexName();
        this.id = shardId.getId();
        this.indexParts = new IndexParts(indexName);
        if (this.indexParts.isPartitioned()) {
            this.partitionIdent = this.indexParts.getPartitionIdent();
            RelationName relationName = this.indexParts.toRelationName();
            this.aliasName = relationName.indexNameOrAlias();
            this.templateName = PartitionName.templateName(relationName.schema(), relationName.name());
        } else {
            this.partitionIdent = "";
            this.aliasName = null;
            this.templateName = null;
        }
        this.path = indexShard.shardPath().getDataPath().toString();
        this.blobPath = blobShard == null ? null : blobShard.blobContainer().getBaseDirectory().toString();
    }

    public IndexShard indexShard() {
        return this.indexShard;
    }

    @Nullable
    BlobShard blobShard() {
        return this.blobShard;
    }

    public ClusterService clusterService() {
        return this.clusterService;
    }

    public IndexParts indexParts() {
        return this.indexParts;
    }

    public Long size() {
        return this.sizeSupplier.get();
    }

    public String partitionIdent() {
        return this.partitionIdent;
    }

    public int id() {
        return this.id;
    }

    public String path() {
        return this.path;
    }

    @Nullable
    public String blobPath() {
        return this.blobPath;
    }

    @Nullable
    String aliasName() {
        return this.aliasName;
    }

    @Nullable
    public String templateName() {
        return this.templateName;
    }

    @Nullable
    public Long numDocs() {
        if (this.blobShard == null) {
            try {
                return this.indexShard.docStats().getCount();
            }
            catch (IllegalIndexShardStateException e) {
                return null;
            }
        }
        return this.blobShard.getBlobsCount();
    }

    public boolean isOrphanedPartition() {
        if (this.aliasName != null && this.templateName != null) {
            Metadata metadata = this.clusterService.state().metadata();
            return !metadata.templates().containsKey(this.templateName) || !metadata.hasConcreteIndex(this.aliasName);
        }
        return false;
    }

    @Nullable
    public String minLuceneVersion() {
        long numDocs;
        try {
            numDocs = this.indexShard.docStats().getCount();
        }
        catch (IllegalIndexShardStateException e) {
            return null;
        }
        if (numDocs == 0L) {
            return Version.CURRENT.luceneVersion.toString();
        }
        try {
            return this.indexShard.minimumCompatibleVersion().toString();
        }
        catch (AlreadyClosedException e) {
            return null;
        }
    }

    @Nullable
    public Long maxSeqNo() {
        try {
            SeqNoStats stats = this.indexShard.seqNoStats();
            return stats == null ? null : Long.valueOf(stats.getMaxSeqNo());
        }
        catch (AlreadyClosedException e) {
            return 0L;
        }
    }

    @Nullable
    public Long localSeqNoCheckpoint() {
        try {
            SeqNoStats stats = this.indexShard.seqNoStats();
            return stats == null ? null : Long.valueOf(stats.getLocalCheckpoint());
        }
        catch (AlreadyClosedException e) {
            return 0L;
        }
    }

    @Nullable
    public Long globalSeqNoCheckpoint() {
        try {
            SeqNoStats stats = this.indexShard.seqNoStats();
            return stats == null ? null : Long.valueOf(stats.getGlobalCheckpoint());
        }
        catch (AlreadyClosedException e) {
            return 0L;
        }
    }

    @Nullable
    public Long translogSizeInBytes() {
        try {
            TranslogStats stats = this.indexShard.translogStats();
            return stats == null ? null : Long.valueOf(stats.getTranslogSizeInBytes());
        }
        catch (AlreadyClosedException e) {
            return 0L;
        }
    }

    @Nullable
    public Long translogUncommittedSizeInBytes() {
        try {
            TranslogStats stats = this.indexShard.translogStats();
            return stats == null ? null : Long.valueOf(stats.getUncommittedSizeInBytes());
        }
        catch (AlreadyClosedException e) {
            return 0L;
        }
    }

    @Nullable
    public Integer translogEstimatedNumberOfOperations() {
        try {
            TranslogStats stats = this.indexShard.translogStats();
            return stats == null ? null : Integer.valueOf(stats.estimatedNumberOfOperations());
        }
        catch (AlreadyClosedException e) {
            return 0;
        }
    }

    @Nullable
    public Integer translogUncommittedOperations() {
        try {
            TranslogStats stats = this.indexShard.translogStats();
            return stats == null ? null : Integer.valueOf(stats.getUncommittedOperations());
        }
        catch (AlreadyClosedException e) {
            return 0;
        }
    }

    @Nullable
    public String recoveryStage() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : recoveryState.getStage().name();
    }

    @Nullable
    public String recoveryType() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : recoveryState.getRecoverySource().getType().name();
    }

    @Nullable
    public Long recoveryTotalTime() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Long.valueOf(recoveryState.getTimer().time());
    }

    @Nullable
    public Long recoverySizeUsed() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Long.valueOf(recoveryState.getIndex().totalBytes());
    }

    @Nullable
    public Long recoverySizeReused() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Long.valueOf(recoveryState.getIndex().reusedBytes());
    }

    @Nullable
    public Long recoverySizeRecoveredBytes() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Long.valueOf(recoveryState.getIndex().recoveredBytes());
    }

    @Nullable
    public Float recoverySizeRecoveredBytesPercent() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Float.valueOf(recoveryState.getIndex().recoveredBytesPercent());
    }

    @Nullable
    public Integer recoveryFilesUsed() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Integer.valueOf(recoveryState.getIndex().totalFileCount());
    }

    @Nullable
    public Integer recoveryFilesReused() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Integer.valueOf(recoveryState.getIndex().reusedFileCount());
    }

    @Nullable
    public Integer recoveryFilesRecovered() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Integer.valueOf(recoveryState.getIndex().recoveredFileCount());
    }

    @Nullable
    public Float recoveryFilesPercent() {
        RecoveryState recoveryState = this.indexShard.recoveryState();
        return recoveryState == null ? null : Float.valueOf(recoveryState.getIndex().recoveredFilesPercent());
    }

    public Long retentionLeasesPrimaryTerm() {
        try {
            return this.indexShard.getRetentionLeaseStats().leases().primaryTerm();
        }
        catch (AlreadyClosedException | IndexShardClosedException e) {
            return null;
        }
    }

    public Long retentionLeasesVersion() {
        try {
            return this.indexShard.getRetentionLeaseStats().leases().version();
        }
        catch (AlreadyClosedException | IndexShardClosedException e) {
            return null;
        }
    }

    public Collection<RetentionLease> retentionLeases() {
        try {
            return this.indexShard.getRetentionLeaseStats().leases().leases();
        }
        catch (AlreadyClosedException | IndexShardClosedException e) {
            return List.of();
        }
    }
}

