/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.operation;

import io.crate.expression.reference.sys.job.ContextLog;
import io.crate.expression.reference.sys.operation.OperationContext;
import java.util.UUID;
import javax.annotation.Nullable;

public class OperationContextLog
implements ContextLog {
    @Nullable
    private final String errorMessage;
    private final long ended;
    private final int id;
    private final UUID jobId;
    private final String name;
    private final long started;
    private final long usedBytes;

    public OperationContextLog(OperationContext operationContext, @Nullable String errorMessage) {
        this.id = operationContext.id();
        this.jobId = operationContext.jobId();
        this.name = operationContext.name();
        this.started = operationContext.started();
        this.usedBytes = operationContext.usedBytes();
        this.errorMessage = errorMessage;
        this.ended = System.currentTimeMillis();
    }

    public int id() {
        return this.id;
    }

    public UUID jobId() {
        return this.jobId;
    }

    public String name() {
        return this.name;
    }

    public long started() {
        return this.started;
    }

    @Override
    public long ended() {
        return this.ended;
    }

    public long usedBytes() {
        return this.usedBytes;
    }

    @Nullable
    public String errorMessage() {
        return this.errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationContextLog that = (OperationContextLog)o;
        if (this.id != that.id) {
            return false;
        }
        return this.jobId.equals(that.jobId);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.jobId.hashCode();
        return result;
    }

    public String toString() {
        return "OperationContextLog{errorMessage='" + this.errorMessage + "', id=" + this.id + ", jobId=" + this.jobId + ", name='" + this.name + "', usedBytes=" + this.usedBytes + "}";
    }
}

