/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.data.Input;
import io.crate.expression.reference.sys.SysRowUpdater;
import io.crate.expression.reference.sys.check.node.SysNodeCheck;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.sys.SysNodeChecksTableInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.discovery.Discovery;

@Singleton
public class SysNodeChecks
implements SysRowUpdater<SysNodeCheck>,
Iterable<SysNodeCheck> {
    private final Map<String, SysNodeCheck> checks;
    private static final BiConsumer<SysNodeCheck, Input<?>> ACK_WRITER = (row, input) -> row.acknowledged((Boolean)input.value());

    @Inject
    public SysNodeChecks(final Map<Integer, SysNodeCheck> checks, Discovery discovery, final ClusterService clusterService) {
        this.checks = new HashMap<String, SysNodeCheck>(checks.size());
        discovery.addLifecycleListener(new LifecycleListener(){

            @Override
            public void afterStart() {
                String nodeId = clusterService.localNode().getId();
                for (SysNodeCheck sysNodeCheck : checks.values()) {
                    sysNodeCheck.setNodeId(nodeId);
                    SysNodeChecks.this.checks.put(sysNodeCheck.rowId(), sysNodeCheck);
                }
            }
        });
    }

    @Override
    public SysNodeCheck getRow(Object id) {
        return this.checks.get(id);
    }

    @Override
    public BiConsumer<SysNodeCheck, Input<?>> getWriter(ColumnIdent ci) {
        if (SysNodeChecksTableInfo.Columns.ACKNOWLEDGED.equals(ci)) {
            return ACK_WRITER;
        }
        return null;
    }

    @Override
    public Iterator<SysNodeCheck> iterator() {
        return this.checks.values().iterator();
    }
}

