/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.AbstractSysNodeCheck;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;

@Singleton
public class RecoveryExpectedNodesSysCheck
extends AbstractSysNodeCheck {
    private final ClusterService clusterService;
    private final Settings settings;
    static final int ID = 1;
    private static final String DESCRIPTION = "The value of the cluster setting 'gateway.expected_nodes' must be equal to the maximum/expected number of master and data nodes in the cluster.";

    @Inject
    public RecoveryExpectedNodesSysCheck(ClusterService clusterService, Settings settings) {
        super(1, DESCRIPTION, SysCheck.Severity.HIGH);
        this.clusterService = clusterService;
        this.settings = settings;
    }

    @Override
    public boolean isValid() {
        return this.validate(this.clusterService.state().nodes().getMasterAndDataNodes().size(), GatewayService.EXPECTED_NODES_SETTING.get(this.settings));
    }

    protected boolean validate(int dataAndMaster, int expectedNodes) {
        return dataAndMaster == 1 || dataAndMaster == expectedNodes;
    }
}

