/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.AbstractSysNodeCheck;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;

@Singleton
public class RecoveryAfterNodesSysCheck
extends AbstractSysNodeCheck {
    private final ClusterService clusterService;
    private final Settings settings;
    static final int ID = 2;
    private static final String DESCRIPTION = "The value of the cluster setting 'gateway.recover_after_nodes' needs to be greater than half of the maximum/expected number of nodes and equal or less than the maximum/expected number of nodes in the cluster.";

    @Inject
    public RecoveryAfterNodesSysCheck(ClusterService clusterService, Settings settings) {
        super(2, DESCRIPTION, SysCheck.Severity.HIGH);
        this.clusterService = clusterService;
        this.settings = settings;
    }

    @Override
    public boolean isValid() {
        return this.validate(GatewayService.RECOVER_AFTER_NODES_SETTING.get(this.settings), GatewayService.EXPECTED_NODES_SETTING.get(this.settings));
    }

    protected boolean validate(int afterNodes, int expectedNodes) {
        return this.clusterService.state().nodes().getSize() == 1 || expectedNodes / 2 < afterNodes && afterNodes <= expectedNodes;
    }
}

