/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.DiskWatermarkNodesSysCheck;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.NodeService;

@Singleton
public class LowDiskWatermarkNodesSysCheck
extends DiskWatermarkNodesSysCheck {
    static final int ID = 6;
    private static final String DESCRIPTION = "The low disk watermark is exceeded on the node. The cluster will not allocate new shards to the node. Please check the node disk usage.";

    @Inject
    public LowDiskWatermarkNodesSysCheck(ClusterService clusterService, Settings settings, NodeService nodeService) {
        super(6, DESCRIPTION, SysCheck.Severity.HIGH, clusterService, nodeService.getMonitorService().fsService(), settings);
    }

    @Override
    protected boolean isValid(long free, long total) {
        return free >= this.diskThresholdSettings.getFreeBytesThresholdLow().getBytes() && !(LowDiskWatermarkNodesSysCheck.getFreeDiskAsPercentage(free, total) < this.diskThresholdSettings.getFreeDiskThresholdLow());
    }
}

