/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.AbstractSysNodeCheck;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.fs.FsService;

abstract class DiskWatermarkNodesSysCheck
extends AbstractSysNodeCheck {
    private final FsService fsService;
    final DiskThresholdSettings diskThresholdSettings;

    DiskWatermarkNodesSysCheck(int id, String description, SysCheck.Severity severity, ClusterService clusterService, FsService fsService, Settings settings) {
        super(id, description, severity);
        this.fsService = fsService;
        this.diskThresholdSettings = new DiskThresholdSettings(settings, clusterService.getClusterSettings());
    }

    @Override
    public boolean isValid() {
        if (!this.diskThresholdSettings.isEnabled()) {
            return true;
        }
        DiskUsage leastDiskEstimate = this.fsService.stats().getLeastDiskEstimate();
        if (leastDiskEstimate == null) {
            return true;
        }
        return this.isValid(leastDiskEstimate.getFreeBytes(), leastDiskEstimate.getTotalBytes());
    }

    protected abstract boolean isValid(long var1, long var3);

    static double getFreeDiskAsPercentage(long free, long total) {
        if (total == 0L) {
            return 100.0;
        }
        return 100.0 * ((double)free / (double)total);
    }
}

