/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.cluster;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.expression.reference.sys.check.AbstractSysCheck;
import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.metadata.RelationName;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class TablesNeedUpgradeSysCheck
extends AbstractSysCheck {
    public static final int ID = 3;
    public static final String DESCRIPTION = "The following tables need to be recreated for compatibility with future major versions of CrateDB: ";
    private final ClusterService clusterService;
    private volatile Collection<String> tablesNeedUpgrade;

    @Inject
    public TablesNeedUpgradeSysCheck(ClusterService clusterService) {
        super(3, DESCRIPTION, SysCheck.Severity.LOW);
        this.clusterService = clusterService;
    }

    @Override
    public String description() {
        return DESCRIPTION + this.tablesNeedUpgrade + " https://cr8.is/d-cluster-check-3";
    }

    @Override
    public CompletableFuture<?> computeResult() {
        HashSet<String> fqTables = new HashSet<String>();
        for (ObjectCursor cursor : this.clusterService.state().metadata().indices().values()) {
            if (((IndexMetadata)cursor.value).getCreationVersion().major >= Version.CURRENT.major) continue;
            fqTables.add(RelationName.fqnFromIndexName(((IndexMetadata)cursor.value).getIndex().getName()));
        }
        this.tablesNeedUpgrade = fqTables;
        return CompletableFuture.completedFuture(fqTables);
    }

    @Override
    public boolean isValid() {
        return this.tablesNeedUpgrade == null || this.tablesNeedUpgrade.isEmpty();
    }
}

