/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.cluster;

import io.crate.expression.reference.sys.check.AbstractSysCheck;
import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocSchemaInfo;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class NumberOfPartitionsSysCheck
extends AbstractSysCheck {
    private static final int ID = 2;
    private static final String DESCRIPTION = "The total number of partitions of one or more partitioned tables should not be greater than 1000. A large amount of shards can significantly reduce performance.";
    private static final int PARTITIONS_THRESHOLD = 1000;
    private final Schemas schemas;

    @Inject
    public NumberOfPartitionsSysCheck(Schemas schemas) {
        super(2, DESCRIPTION, SysCheck.Severity.MEDIUM);
        this.schemas = schemas;
    }

    @Override
    public boolean isValid() {
        for (SchemaInfo schemaInfo : this.schemas) {
            if (!(schemaInfo instanceof DocSchemaInfo) || this.validateDocTablesPartitioning(schemaInfo)) continue;
            return false;
        }
        return true;
    }

    boolean validateDocTablesPartitioning(SchemaInfo schemaInfo) {
        for (TableInfo tableInfo : schemaInfo.getTables()) {
            DocTableInfo docTableInfo = (DocTableInfo)tableInfo;
            if (!docTableInfo.isPartitioned() || docTableInfo.partitions().size() <= 1000) continue;
            return false;
        }
        return true;
    }
}

