/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.partitioned;

import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;

public class PartitionExpression
implements NestableCollectExpression<PartitionName, Object> {
    private final Reference ref;
    private final int valuesIndex;
    private Object value;

    public PartitionExpression(Reference ref, int valuesIndex) {
        this.ref = ref;
        this.valuesIndex = valuesIndex;
    }

    @Override
    public void setNextRow(PartitionName row) {
        assert (row != null) : "row shouldn't be null for PartitionExpression";
        this.value = this.ref.valueType().implicitCast(row.values().get(this.valuesIndex));
    }

    @Override
    public Object value() {
        return this.value;
    }

    public Reference reference() {
        return this.ref;
    }
}

