/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.file;

import io.crate.metadata.ColumnIdent;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public class LineContext {
    private byte[] rawSource;
    private Map<String, Object> parsedSource;
    private String currentUri;
    private String currentUriFailure;
    private long currentLineNumber = 0L;

    @Nullable
    String sourceAsString() {
        if (this.rawSource != null) {
            char[] chars = new char[this.rawSource.length];
            int len = UnicodeUtil.UTF8toUTF16((byte[])this.rawSource, (int)0, (int)this.rawSource.length, (char[])chars);
            return new String(chars, 0, len);
        }
        return null;
    }

    @Nullable
    Map<String, Object> sourceAsMap() {
        if (this.parsedSource == null && this.rawSource != null) {
            try {
                this.parsedSource = XContentHelper.toMap(new BytesArray(this.rawSource), XContentType.JSON);
            }
            catch (ElasticsearchParseException | NotXContentException e) {
                throw new RuntimeException("JSON parser error: " + e.getMessage(), e);
            }
        }
        return this.parsedSource;
    }

    public Object get(ColumnIdent columnIdent) {
        Map<String, Object> parentMap = this.sourceAsMap();
        if (parentMap == null) {
            return null;
        }
        return ColumnIdent.get(parentMap, columnIdent);
    }

    public void rawSource(byte[] bytes) {
        this.rawSource = bytes;
        this.parsedSource = null;
    }

    public void currentUri(URI currentUri) {
        this.currentUri = currentUri.toString();
        this.currentUriFailure = null;
    }

    String currentUri() {
        return this.currentUri;
    }

    public void setCurrentUriFailure(String failureMessage) {
        this.currentUriFailure = failureMessage;
    }

    @Nullable
    String getCurrentUriFailure() {
        return this.currentUriFailure;
    }

    public void resetCurrentLineNumber() {
        this.currentLineNumber = 0L;
    }

    public void incrementCurrentLineNumber() {
        ++this.currentLineNumber;
    }

    long getCurrentLineNumber() {
        return this.currentLineNumber;
    }
}

