/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.file;

import io.crate.execution.engine.collect.files.LineCollectorExpression;
import io.crate.expression.reference.file.ColumnExtractingLineExpression;
import io.crate.expression.reference.file.SourceAsMapLineExpression;
import io.crate.expression.reference.file.SourceLineExpression;
import io.crate.expression.reference.file.SourceLineNumberExpression;
import io.crate.expression.reference.file.SourceUriExpression;
import io.crate.expression.reference.file.SourceUriFailureExpression;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import java.util.Map;
import java.util.function.Supplier;

public final class FileLineReferenceResolver {
    private static final Map<String, Supplier<LineCollectorExpression<?>>> EXPRESSION_BUILDER = Map.of(SourceLineExpression.COLUMN_NAME, SourceLineExpression::new, SourceAsMapLineExpression.COLUMN_NAME, SourceAsMapLineExpression::new, "_uri", SourceUriExpression::new, "_uri_failure", SourceUriFailureExpression::new, "_line_number", SourceLineNumberExpression::new);

    private FileLineReferenceResolver() {
    }

    public static LineCollectorExpression<?> getImplementation(Reference refInfo) {
        ColumnIdent columnIdent = refInfo.column();
        Supplier<LineCollectorExpression<?>> supplier = EXPRESSION_BUILDER.get(columnIdent.name());
        if (supplier == null) {
            return new ColumnExtractingLineExpression(columnIdent);
        }
        return supplier.get();
    }
}

