/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.doc.DocSysColumns;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public final class SourceParser {
    private static final Object FULL_OBJECT = new Object();
    private final Map<String, Object> requiredColumns = new HashMap<String, Object>();

    public void register(ColumnIdent docColumn) {
        assert (docColumn.name().equals(DocSysColumns.DOC.name()) && docColumn.path().size() > 0) : "All columns registered for sourceParser must start with _doc";
        List<String> path = docColumn.path();
        if (path.size() == 1) {
            this.requiredColumns.put(docColumn.path().get(0), FULL_OBJECT);
        } else {
            HashMap<String, Object> columns = this.requiredColumns;
            for (int i = 0; i < path.size(); ++i) {
                String part = path.get(i);
                if (i + 1 == path.size()) {
                    columns.put(part, FULL_OBJECT);
                    continue;
                }
                Object object = columns.get(part);
                if (object instanceof Map) {
                    columns = (HashMap<String, Object>)object;
                    continue;
                }
                if (object == FULL_OBJECT) break;
                HashMap<String, Object> children = new HashMap<String, Object>();
                columns.put(part, children);
                columns = children;
            }
        }
    }

    public Map<String, Object> parse(BytesReference bytes) {
        HashMap<String, Object> hashMap;
        block18: {
            InputStream inputStream = XContentHelper.getUncompressedInputStream(bytes);
            try {
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, inputStream);
                XContentParser.Token token = parser.currentToken();
                if (token == null) {
                    token = parser.nextToken();
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    token = parser.nextToken();
                }
                HashMap<String, Object> result = new HashMap<String, Object>();
                while (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    parser.nextToken();
                    if (this.requiredColumns.isEmpty()) {
                        result.put(fieldName, SourceParser.parseValue(parser, null));
                    } else {
                        Object required = this.requiredColumns.get(fieldName);
                        if (required == null) {
                            parser.skipChildren();
                        } else if (required == FULL_OBJECT) {
                            result.put(fieldName, SourceParser.parseValue(parser, null));
                        } else {
                            assert (required instanceof Map) : "requiredColumns must either contain the FULL_OBJECT marker or a Map with child columns to load";
                            result.put(fieldName, SourceParser.parseValue(parser, (Map)required));
                        }
                    }
                    token = parser.nextToken();
                }
                hashMap = result;
                if (inputStream == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            inputStream.close();
        }
        return hashMap;
    }

    private static Object parseValue(XContentParser parser, @Nullable Map<String, Object> requiredColumns) throws IOException {
        return switch (parser.currentToken()) {
            case XContentParser.Token.VALUE_NULL -> null;
            case XContentParser.Token.START_ARRAY -> {
                ArrayList<Object> values = new ArrayList<Object>();
                XContentParser.Token token = parser.nextToken();
                while (token != null && token != XContentParser.Token.END_ARRAY) {
                    values.add(SourceParser.parseValue(parser, requiredColumns));
                    token = parser.nextToken();
                }
                yield values;
            }
            case XContentParser.Token.START_OBJECT -> {
                if (requiredColumns == null) {
                    yield parser.map();
                }
                HashMap<String, Object> values = new HashMap<String, Object>();
                XContentParser.Token token = parser.nextToken();
                while (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    parser.nextToken();
                    Object required = requiredColumns.get(fieldName);
                    if (required == null) {
                        parser.skipChildren();
                    } else if (required == FULL_OBJECT) {
                        values.put(fieldName, SourceParser.parseValue(parser, null));
                    } else {
                        values.put(fieldName, SourceParser.parseValue(parser, (Map)required));
                    }
                    token = parser.nextToken();
                }
                yield values;
            }
            case XContentParser.Token.VALUE_STRING -> parser.text();
            case XContentParser.Token.VALUE_NUMBER -> parser.numberValue();
            case XContentParser.Token.VALUE_BOOLEAN -> parser.booleanValue();
            case XContentParser.Token.VALUE_EMBEDDED_OBJECT -> (HashMap<String, Object>)parser.binaryValue();
            default -> throw new UnsupportedOperationException("Unsupported token encountered, expected a value, got " + parser.currentToken());
        };
    }
}

