/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.SourceFieldVisitor;
import io.crate.expression.reference.doc.lucene.SourceParser;
import io.crate.metadata.Reference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.elasticsearch.common.bytes.BytesReference;

public final class SourceLookup {
    private final SourceFieldVisitor fieldsVisitor = new SourceFieldVisitor();
    private final SourceParser sourceParser = new SourceParser();
    private int doc;
    private ReaderContext readerContext;
    private Map<String, Object> source;
    private boolean docVisited = false;

    SourceLookup() {
    }

    public void setSegmentAndDocument(ReaderContext context, int doc) {
        if (this.doc == doc && this.readerContext != null && this.readerContext.reader() == context.reader()) {
            return;
        }
        this.fieldsVisitor.reset();
        this.docVisited = false;
        this.source = null;
        this.doc = doc;
        this.readerContext = context;
    }

    public Object get(List<String> path) {
        this.ensureSourceParsed();
        return SourceLookup.extractValue(this.source, path, 0);
    }

    public Map<String, Object> sourceAsMap() {
        this.ensureSourceParsed();
        return this.source;
    }

    public BytesReference rawSource() {
        this.ensureDocVisited();
        return this.fieldsVisitor.source();
    }

    private void ensureSourceParsed() {
        if (this.source == null) {
            this.ensureDocVisited();
            this.source = this.sourceParser.parse(this.fieldsVisitor.source());
        }
    }

    private void ensureDocVisited() {
        if (this.docVisited) {
            return;
        }
        try {
            this.readerContext.visitDocument(this.doc, this.fieldsVisitor);
            this.docVisited = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Object extractValue(Map<?, ?> map, List<String> path, int pathStartIndex) {
        assert (path instanceof RandomAccess) : "path should support RandomAccess for fast index optimized loop";
        Map m = map;
        Object tmp = null;
        for (int i = pathStartIndex; i < path.size(); ++i) {
            tmp = m.get(path.get(i));
            if (!(tmp instanceof Map)) {
                if (!(tmp instanceof List)) break;
                List list = tmp;
                if (i + 1 == path.size()) {
                    return list;
                }
                ArrayList<Object> newList = new ArrayList<Object>(list.size());
                for (Object o : list) {
                    if (o instanceof Map) {
                        newList.add(SourceLookup.extractValue((Map)o, path, i + 1));
                        continue;
                    }
                    newList.add(o);
                }
                return newList;
            }
            m = tmp;
        }
        return tmp;
    }

    public SourceLookup registerRef(Reference ref) {
        this.sourceParser.register(ref.column());
        return this;
    }
}

