/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.metadata.doc.DocSysColumns;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.NumericDocValues;

public class SeqNoCollectorExpression
extends LuceneCollectorExpression<Long> {
    private NumericDocValues seqNumbers = null;
    private int doc;

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        try {
            this.seqNumbers = context.reader().getNumericDocValues(DocSysColumns.SEQ_NO.name());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setNextDocId(int doc) {
        this.doc = doc;
    }

    @Override
    public Long value() {
        try {
            if (this.seqNumbers != null && this.seqNumbers.advanceExact(this.doc)) {
                return this.seqNumbers.longValue();
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

