/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.SourceLookup;
import java.io.IOException;
import org.elasticsearch.common.compress.CompressorFactory;

public class RawCollectorExpression
extends LuceneCollectorExpression<String> {
    private SourceLookup sourceLookup;
    private ReaderContext context;

    @Override
    public void startCollect(CollectorContext context) {
        this.sourceLookup = context.sourceLookup();
    }

    @Override
    public void setNextDocId(int doc) {
        this.sourceLookup.setSegmentAndDocument(this.context, doc);
    }

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        this.context = context;
    }

    @Override
    public String value() {
        try {
            return CompressorFactory.uncompressIfNeeded(this.sourceLookup.rawSource()).utf8ToString();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to uncompress source", e);
        }
    }
}

