/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.metadata.doc.DocSysColumns;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.NumericDocValues;

public class PrimaryTermCollectorExpression
extends LuceneCollectorExpression<Long> {
    private NumericDocValues primaryTerms = null;
    private int doc;

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        try {
            this.primaryTerms = context.reader().getNumericDocValues(DocSysColumns.PRIMARY_TERM.name());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setNextDocId(int doc) {
        this.doc = doc;
    }

    @Override
    public Long value() {
        try {
            if (this.primaryTerms != null && this.primaryTerms.advanceExact(this.doc)) {
                return this.primaryTerms.longValue();
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

