/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.analyze.OrderBy;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.NullSentinelValues;
import io.crate.metadata.Reference;
import java.util.function.Function;
import org.apache.lucene.search.FieldDoc;

public class OrderByCollectorExpression
extends LuceneCollectorExpression<Object> {
    private final int orderIndex;
    private final Function<Object, Object> valueConversion;
    private final Object missingValue;
    private Object value;

    public OrderByCollectorExpression(Reference ref, OrderBy orderBy, Function<Object, Object> valueConversion) {
        this.valueConversion = valueConversion;
        assert (orderBy.orderBySymbols().contains(ref)) : "symbol must be part of orderBy symbols";
        this.orderIndex = orderBy.orderBySymbols().indexOf(ref);
        this.missingValue = NullSentinelValues.nullSentinelForScoreDoc(orderBy, this.orderIndex);
    }

    private void value(Object value) {
        this.value = this.missingValue != null && this.missingValue.equals(value) ? null : this.valueConversion.apply(value);
    }

    public void setNextFieldDoc(FieldDoc fieldDoc) {
        this.value(fieldDoc.fields[this.orderIndex]);
    }

    @Override
    public Object value() {
        return this.value;
    }

    public String toString() {
        return "OrderByCollectorExpression{idx=" + this.orderIndex + "}";
    }
}

