/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.analyze.OrderBy;
import io.crate.types.DataType;
import javax.annotation.Nullable;
import org.apache.lucene.search.SortField;
import org.elasticsearch.index.fielddata.NullValueOrder;

public class NullSentinelValues {
    public static Object nullSentinelForScoreDoc(OrderBy orderBy, int orderIndex) {
        assert (orderIndex <= orderBy.orderBySymbols().size()) : "orderIndex must be < number of orderBy symbols";
        return NullSentinelValues.nullSentinelForScoreDoc(orderBy.orderBySymbols().get(orderIndex).valueType(), orderBy.reverseFlags()[orderIndex], orderBy.nullsFirst()[orderIndex]);
    }

    public static Object nullSentinelForReducedType(SortField.Type reducedType, NullValueOrder nullValueOrder, boolean reversed) {
        boolean min = nullValueOrder == NullValueOrder.FIRST ^ reversed;
        switch (reducedType) {
            case INT: {
                return min ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            }
            case LONG: {
                return min ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            case FLOAT: {
                return Float.valueOf(min ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
            }
            case DOUBLE: {
                return min ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            case STRING: 
            case STRING_VAL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unsupported reduced type: " + reducedType);
    }

    public static Object nullSentinelForScoreDoc(DataType<?> type, boolean reverseFlag, Boolean nullFirst) {
        boolean min = reverseFlag ^ (nullFirst != null ? nullFirst : reverseFlag);
        switch (type.id()) {
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                return min ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            case 7: {
                return Float.valueOf(min ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
            }
            case 6: {
                return min ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        }
        return null;
    }

    @Nullable
    public static Object nullSentinel(DataType<?> dataType, NullValueOrder nullValueOrder, boolean reversed) {
        boolean min = nullValueOrder == NullValueOrder.FIRST ^ reversed;
        switch (dataType.id()) {
            case 2: {
                return min ? (byte)-128 : 127;
            }
            case 8: {
                return min ? (short)Short.MIN_VALUE : Short.MAX_VALUE;
            }
            case 9: {
                return min ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            }
            case 10: 
            case 11: 
            case 15: {
                return min ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            case 7: {
                return Float.valueOf(min ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
            }
            case 6: {
                return min ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        }
        return null;
    }
}

