/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.common.collections.Maps;
import io.crate.exceptions.UnhandledServerException;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.reference.doc.lucene.BooleanColumnReference;
import io.crate.expression.reference.doc.lucene.ByteColumnReference;
import io.crate.expression.reference.doc.lucene.BytesRefColumnReference;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.DocCollectorExpression;
import io.crate.expression.reference.doc.lucene.DocIdCollectorExpression;
import io.crate.expression.reference.doc.lucene.DoubleColumnReference;
import io.crate.expression.reference.doc.lucene.FetchIdCollectorExpression;
import io.crate.expression.reference.doc.lucene.FloatColumnReference;
import io.crate.expression.reference.doc.lucene.GeoPointColumnReference;
import io.crate.expression.reference.doc.lucene.IdCollectorExpression;
import io.crate.expression.reference.doc.lucene.IntegerColumnReference;
import io.crate.expression.reference.doc.lucene.IpColumnReference;
import io.crate.expression.reference.doc.lucene.LongColumnReference;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.PrimaryTermCollectorExpression;
import io.crate.expression.reference.doc.lucene.RawCollectorExpression;
import io.crate.expression.reference.doc.lucene.ScoreCollectorExpression;
import io.crate.expression.reference.doc.lucene.SeqNoCollectorExpression;
import io.crate.expression.reference.doc.lucene.ShortColumnReference;
import io.crate.expression.reference.doc.lucene.VersionCollectorExpression;
import io.crate.expression.symbol.SymbolType;
import io.crate.lucene.FieldTypeLookup;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.DocReferences;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.index.mapper.MappedFieldType;

public class LuceneReferenceResolver
implements ReferenceResolver<LuceneCollectorExpression<?>> {
    private static final Set<Integer> NO_FIELD_TYPES_IDS = Set.of(Integer.valueOf(12), Integer.valueOf(14));
    private final FieldTypeLookup fieldTypeLookup;
    private final List<Reference> partitionColumns;
    private final String indexName;

    public LuceneReferenceResolver(String indexName, FieldTypeLookup fieldTypeLookup, List<Reference> partitionColumns) {
        this.indexName = indexName;
        this.fieldTypeLookup = fieldTypeLookup;
        this.partitionColumns = partitionColumns;
    }

    @Override
    public LuceneCollectorExpression<?> getImplementation(Reference ref) {
        ColumnIdent column = ref.column();
        switch (column.name()) {
            case "_raw": {
                if (column.isTopLevel()) {
                    return new RawCollectorExpression();
                }
                throw new UnsupportedFeatureException("_raw expression does not support subscripts: " + column);
            }
            case "_uid": 
            case "_id": {
                return new IdCollectorExpression();
            }
            case "_fetchid": {
                return new FetchIdCollectorExpression();
            }
            case "_docid": {
                return new DocIdCollectorExpression();
            }
            case "_score": {
                return new ScoreCollectorExpression();
            }
            case "_version": {
                return new VersionCollectorExpression();
            }
            case "_seq_no": {
                return new SeqNoCollectorExpression();
            }
            case "_primary_term": {
                return new PrimaryTermCollectorExpression();
            }
            case "_doc": {
                LuceneCollectorExpression<?> result = DocCollectorExpression.create(ref);
                return LuceneReferenceResolver.maybeInjectPartitionValue(result, this.indexName, this.partitionColumns, column.isTopLevel() ? column : column.shiftRight());
            }
        }
        int partitionPos = this.partitionColumns.indexOf(ref);
        if (partitionPos >= 0) {
            return new LiteralValueExpression(ref.valueType().implicitCast(PartitionName.fromIndexOrTemplate(this.indexName).values().get(partitionPos)));
        }
        return LuceneReferenceResolver.maybeInjectPartitionValue(LuceneReferenceResolver.typeSpecializedExpression(this.fieldTypeLookup, ref), this.indexName, this.partitionColumns, column);
    }

    private static LuceneCollectorExpression<?> maybeInjectPartitionValue(LuceneCollectorExpression<?> result, String indexName, List<Reference> partitionColumns, ColumnIdent column) {
        for (int i = 0; i < partitionColumns.size(); ++i) {
            Reference partitionColumn = partitionColumns.get(i);
            ColumnIdent partitionColumnIdent = partitionColumn.column();
            if (!partitionColumnIdent.isChildOf(column)) continue;
            return new PartitionValueInjectingExpression(PartitionName.fromIndexOrTemplate(indexName), i, partitionColumnIdent.shiftRight(), result);
        }
        return result;
    }

    private static LuceneCollectorExpression<?> typeSpecializedExpression(FieldTypeLookup fieldTypeLookup, Reference ref) {
        String fqn = ref.column().fqn();
        MappedFieldType fieldType = fieldTypeLookup.get(fqn);
        if (fieldType == null) {
            return NO_FIELD_TYPES_IDS.contains(ArrayType.unnest(ref.valueType()).id()) || LuceneReferenceResolver.isIgnoredDynamicReference(ref) ? DocCollectorExpression.create(DocReferences.toSourceLookup(ref)) : new LiteralValueExpression(null);
        }
        if (!fieldType.hasDocValues()) {
            return DocCollectorExpression.create(DocReferences.toSourceLookup(ref));
        }
        switch (ref.valueType().id()) {
            case 2: {
                return new ByteColumnReference(fqn);
            }
            case 8: {
                return new ShortColumnReference(fqn);
            }
            case 5: {
                return new IpColumnReference(fqn);
            }
            case 4: {
                return new BytesRefColumnReference(fqn);
            }
            case 6: {
                return new DoubleColumnReference(fqn);
            }
            case 3: {
                return new BooleanColumnReference(fqn);
            }
            case 7: {
                return new FloatColumnReference(fqn);
            }
            case 10: 
            case 11: 
            case 15: {
                return new LongColumnReference(fqn);
            }
            case 9: {
                return new IntegerColumnReference(fqn);
            }
            case 13: {
                return new GeoPointColumnReference(fqn);
            }
            case 100: {
                return DocCollectorExpression.create(DocReferences.toSourceLookup(ref));
            }
        }
        throw new UnhandledServerException("Unsupported type: " + ref.valueType().getName());
    }

    private static boolean isIgnoredDynamicReference(Reference ref) {
        return ref.symbolType() == SymbolType.DYNAMIC_REFERENCE && ref.columnPolicy() == ColumnPolicy.IGNORED;
    }

    private static class LiteralValueExpression
    extends LuceneCollectorExpression<Object> {
        private final Object value;

        public LiteralValueExpression(Object value) {
            this.value = value;
        }

        @Override
        public Object value() {
            return this.value;
        }
    }

    static class PartitionValueInjectingExpression
    extends LuceneCollectorExpression<Object> {
        private final LuceneCollectorExpression<?> inner;
        private final ColumnIdent partitionPath;
        private final int partitionPos;
        private final PartitionName partitionName;

        public PartitionValueInjectingExpression(PartitionName partitionName, int partitionPos, ColumnIdent partitionPath, LuceneCollectorExpression<?> inner) {
            this.inner = inner;
            this.partitionName = partitionName;
            this.partitionPos = partitionPos;
            this.partitionPath = partitionPath;
        }

        @Override
        public Object value() {
            Map object = (Map)this.inner.value();
            String partitionValue = this.partitionName.values().get(this.partitionPos);
            Maps.mergeInto(object, this.partitionPath.name(), this.partitionPath.path(), partitionValue);
            return object;
        }

        @Override
        public void startCollect(CollectorContext context) {
            this.inner.startCollect(context);
        }

        @Override
        public void setNextDocId(int doc) {
            this.inner.setNextDocId(doc);
        }

        @Override
        public void setNextReader(ReaderContext context) throws IOException {
            this.inner.setNextReader(context);
        }

        @Override
        public void setScorer(Scorable scorer) {
            this.inner.setScorer(scorer);
        }
    }
}

