/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.exceptions.GroupByOnArrayUnsupportedException;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.search.DocValueFormat;

public class IpColumnReference
extends LuceneCollectorExpression<String> {
    private final String columnName;
    private SortedSetDocValues values;
    private int docId;

    public IpColumnReference(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public String value() {
        try {
            if (this.values.advanceExact(this.docId)) {
                long ord = this.values.nextOrd();
                if (this.values.nextOrd() != -1L) {
                    throw new GroupByOnArrayUnsupportedException(this.columnName);
                }
                BytesRef encoded = this.values.lookupOrd(ord);
                return (String)DocValueFormat.IP.format(encoded);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setNextDocId(int docId) {
        this.docId = docId;
    }

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        this.values = context.reader().getSortedSetDocValues(this.columnName);
        if (this.values == null) {
            this.values = DocValues.emptySortedSet();
        }
    }
}

