/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.exceptions.GroupByOnArrayUnsupportedException;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;

public class IntegerColumnReference
extends LuceneCollectorExpression<Integer> {
    private final String columnName;
    private SortedNumericDocValues values;
    private int docId;

    public IntegerColumnReference(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public Integer value() {
        try {
            if (this.values.advanceExact(this.docId)) {
                switch (this.values.docValueCount()) {
                    case 1: {
                        return (int)this.values.nextValue();
                    }
                }
                throw new GroupByOnArrayUnsupportedException(this.columnName);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setNextDocId(int docId) {
        this.docId = docId;
    }

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        super.setNextReader(context);
        this.values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.columnName);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntegerColumnReference)) {
            return false;
        }
        return this.columnName.equals(((IntegerColumnReference)obj).columnName);
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }
}

