/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.exceptions.GroupByOnArrayUnsupportedException;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.impl.PointImpl;

public class GeoPointColumnReference
extends LuceneCollectorExpression<Point> {
    private final String columnName;
    private SortedNumericDocValues values;
    private int docId;

    public GeoPointColumnReference(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public Point value() {
        try {
            if (this.values.advanceExact(this.docId)) {
                switch (this.values.docValueCount()) {
                    case 1: {
                        long encoded = this.values.nextValue();
                        return new PointImpl(GeoEncodingUtils.decodeLongitude((int)((int)encoded)), GeoEncodingUtils.decodeLatitude((int)((int)(encoded >>> 32))), (SpatialContext)JtsSpatialContext.GEO);
                    }
                }
                throw new GroupByOnArrayUnsupportedException(this.columnName);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setNextDocId(int docId) {
        this.docId = docId;
    }

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        super.setNextReader(context);
        this.values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.columnName);
    }
}

