/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.exceptions.GroupByOnArrayUnsupportedException;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

public class DoubleColumnReference
extends LuceneCollectorExpression<Double> {
    private final String columnName;
    private SortedNumericDoubleValues values;
    private int docId;

    public DoubleColumnReference(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public Double value() {
        try {
            if (this.values.advanceExact(this.docId)) {
                switch (this.values.docValueCount()) {
                    case 1: {
                        return this.values.nextValue();
                    }
                }
                throw new GroupByOnArrayUnsupportedException(this.columnName);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setNextDocId(int docId) {
        this.docId = docId;
    }

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        super.setNextReader(context);
        SortedNumericDocValues raw = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.columnName);
        this.values = FieldData.sortableLongBitsToDoubles(raw);
    }
}

