/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.SourceLookup;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocSysColumns;
import java.io.IOException;
import java.util.Map;

public class DocCollectorExpression
extends LuceneCollectorExpression<Map<String, Object>> {
    private SourceLookup sourceLookup;
    private ReaderContext context;

    @Override
    public void startCollect(CollectorContext context) {
        this.sourceLookup = context.sourceLookup();
    }

    @Override
    public void setNextDocId(int doc) {
        this.sourceLookup.setSegmentAndDocument(this.context, doc);
    }

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        this.context = context;
    }

    @Override
    public Map<String, Object> value() {
        return this.sourceLookup.sourceAsMap();
    }

    public static LuceneCollectorExpression<?> create(Reference reference) {
        assert (reference.column().name().equals(DocSysColumns.DOC.name())) : "column name must be " + DocSysColumns.DOC.name();
        if (reference.column().isTopLevel()) {
            return new DocCollectorExpression();
        }
        return new ChildDocCollectorExpression(reference);
    }

    static final class ChildDocCollectorExpression
    extends LuceneCollectorExpression<Object> {
        private final Reference ref;
        private SourceLookup sourceLookup;
        private ReaderContext context;

        ChildDocCollectorExpression(Reference ref) {
            this.ref = ref;
        }

        @Override
        public void setNextDocId(int doc) {
            this.sourceLookup.setSegmentAndDocument(this.context, doc);
        }

        @Override
        public void setNextReader(ReaderContext context) throws IOException {
            this.context = context;
        }

        @Override
        public void startCollect(CollectorContext context) {
            this.sourceLookup = context.sourceLookup(this.ref);
        }

        @Override
        public Object value() {
            return this.ref.valueType().implicitCast(this.sourceLookup.get(this.ref.column().path()));
        }
    }
}

