/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.exceptions.GroupByOnArrayUnsupportedException;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public class BytesRefColumnReference
extends LuceneCollectorExpression<String> {
    private final String columnName;
    private SortedBinaryDocValues values;
    private int docId;

    public BytesRefColumnReference(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public String value() throws GroupByOnArrayUnsupportedException {
        try {
            if (this.values.advanceExact(this.docId)) {
                if (this.values.docValueCount() == 1) {
                    return this.values.nextValue().utf8ToString();
                }
                throw new GroupByOnArrayUnsupportedException(this.columnName);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setNextDocId(int docId) {
        this.docId = docId;
    }

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        super.setNextReader(context);
        this.values = FieldData.toString(DocValues.getSortedSet((LeafReader)context.reader(), (String)this.columnName));
    }
}

