/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.exceptions.GroupByOnArrayUnsupportedException;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public class BooleanColumnReference
extends LuceneCollectorExpression<Boolean> {
    private static final BytesRef TRUE_BYTESREF = new BytesRef((CharSequence)"1");
    private final String columnName;
    private SortedBinaryDocValues values;
    private int docId;

    public BooleanColumnReference(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public Boolean value() {
        try {
            if (this.values.advanceExact(this.docId)) {
                switch (this.values.docValueCount()) {
                    case 1: {
                        return this.values.nextValue().compareTo(TRUE_BYTESREF) == 0;
                    }
                }
                throw new GroupByOnArrayUnsupportedException(this.columnName);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setNextDocId(int docId) {
        this.docId = docId;
    }

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        super.setNextReader(context);
        this.values = FieldData.toString(DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.columnName));
    }
}

