/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference;

import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.expression.NestableInput;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.expressions.RowCollectExpressionFactory;
import java.util.Map;

public class StaticTableReferenceResolver<R>
implements ReferenceResolver<NestableCollectExpression<R, ?>> {
    private final Map<ColumnIdent, ? extends RowCollectExpressionFactory<R>> expressionFactories;

    public StaticTableReferenceResolver(Map<ColumnIdent, ? extends RowCollectExpressionFactory<R>> expressionFactories) {
        this.expressionFactories = expressionFactories;
    }

    @Override
    public NestableCollectExpression<R, ?> getImplementation(Reference ref) {
        return StaticTableReferenceResolver.rowCollectExpressionFromFactoryMap(this.expressionFactories, ref);
    }

    private static <R> NestableCollectExpression<R, ?> rowCollectExpressionFromFactoryMap(Map<ColumnIdent, ? extends RowCollectExpressionFactory<R>> factories, Reference ref) {
        ColumnIdent columnIdent = ref.column();
        RowCollectExpressionFactory<R> factory = factories.get(columnIdent);
        if (factory != null) {
            return factory.create();
        }
        if (columnIdent.isTopLevel()) {
            return null;
        }
        return StaticTableReferenceResolver.getImplementationByRootTraversal(factories, columnIdent);
    }

    private static <R> NestableCollectExpression<R, ?> getImplementationByRootTraversal(Map<ColumnIdent, ? extends RowCollectExpressionFactory<R>> innerFactories, ColumnIdent columnIdent) {
        RowCollectExpressionFactory<R> factory = innerFactories.get(columnIdent.getRoot());
        if (factory == null) {
            return null;
        }
        NestableCollectExpression<R, ?> refImpl = factory.create();
        NestableInput<?> childByPath = NestableInput.getChildByPath(refImpl, columnIdent.path());
        assert (childByPath instanceof NestableCollectExpression) : "Child " + columnIdent.path() + " of " + refImpl + " must be a NestableCollectExpression";
        return (NestableCollectExpression)childByPath;
    }
}

