/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference;

import io.crate.auth.user.User;
import io.crate.expression.reference.StaticTableReferenceResolver;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.expressions.RowCollectExpressionFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public class StaticTableDefinition<T> {
    private final BiFunction<TransactionContext, User, CompletableFuture<? extends Iterable<T>>> recordsForUser;
    private final StaticTableReferenceResolver<T> referenceResolver;
    private final boolean involvesIO;

    public StaticTableDefinition(Supplier<CompletableFuture<? extends Iterable<T>>> iterable, Map<ColumnIdent, ? extends RowCollectExpressionFactory<T>> expressionFactories, boolean involvesIO) {
        this.recordsForUser = (t, u) -> (CompletableFuture)iterable.get();
        this.referenceResolver = new StaticTableReferenceResolver(expressionFactories);
        this.involvesIO = involvesIO;
    }

    public StaticTableDefinition(Supplier<? extends Iterable<T>> iterable, Map<ColumnIdent, ? extends RowCollectExpressionFactory<T>> expressionFactories, BiFunction<TransactionContext, T, T> applyContext) {
        this.recordsForUser = (txnCtx, u) -> CompletableFuture.completedFuture(() -> StaticTableDefinition.lambda$new$2((Supplier)iterable, applyContext, txnCtx));
        this.referenceResolver = new StaticTableReferenceResolver(expressionFactories);
        this.involvesIO = true;
    }

    public StaticTableDefinition(Supplier<? extends Iterable<T>> iterable, BiPredicate<User, T> predicate, Map<ColumnIdent, ? extends RowCollectExpressionFactory<T>> expressionFactories) {
        this.recordsForUser = (txnCtx, u) -> CompletableFuture.completedFuture(() -> StaticTableDefinition.lambda$new$5((Supplier)iterable, u, predicate));
        this.referenceResolver = new StaticTableReferenceResolver(expressionFactories);
        this.involvesIO = true;
    }

    public StaticTableDefinition(Supplier<CompletableFuture<? extends Iterable<T>>> futureRecords, Map<ColumnIdent, ? extends RowCollectExpressionFactory<T>> expressionFactories, BiPredicate<User, T> predicate, boolean involvesIO) {
        this.recordsForUser = (txnCtx, user) -> ((CompletableFuture)futureRecords.get()).thenApply(records -> StreamSupport.stream(records.spliterator(), false).filter(record -> user == null || predicate.test((User)user, (Object)record))::iterator);
        this.referenceResolver = new StaticTableReferenceResolver(expressionFactories);
        this.involvesIO = involvesIO;
    }

    public CompletableFuture<? extends Iterable<T>> retrieveRecords(TransactionContext txnCtx, @Nullable User user) {
        return this.recordsForUser.apply(txnCtx, user);
    }

    public StaticTableReferenceResolver<T> getReferenceResolver() {
        return this.referenceResolver;
    }

    public boolean involvesIO() {
        return this.involvesIO;
    }

    private static /* synthetic */ Iterator lambda$new$5(Supplier iterable, User u, BiPredicate predicate) {
        return StreamSupport.stream(((Iterable)iterable.get()).spliterator(), false).filter(t -> u == null || predicate.test(u, t)).iterator();
    }

    private static /* synthetic */ Iterator lambda$new$2(Supplier iterable, BiFunction applyContext, TransactionContext txnCtx) {
        return StreamSupport.stream(((Iterable)iterable.get()).spliterator(), false).map(record -> applyContext.apply(txnCtx, record)).iterator();
    }
}

