/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference;

import io.crate.common.collections.Maps;
import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.expression.NestableInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class MapLookupByPathExpression<T>
implements NestableCollectExpression<T, Object> {
    private final Function<T, Map<String, Object>> getMap;
    private final List<String> path;
    private final Function<Object, Object> castResultValue;
    private Object value;

    public MapLookupByPathExpression(Function<T, Map<String, Object>> getMap, List<String> path, Function<Object, Object> castResultValue) {
        this.getMap = getMap;
        this.path = path;
        this.castResultValue = castResultValue;
    }

    @Override
    public void setNextRow(T row) {
        this.value = this.path.isEmpty() ? this.getMap.apply(row) : this.castResultValue.apply(Maps.getByPath(this.getMap.apply(row), this.path));
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public NestableInput<?> getChild(String name) {
        ArrayList<String> newPath = new ArrayList<String>(this.path.size() + 1);
        newPath.addAll(this.path);
        newPath.add(name);
        return new MapLookupByPathExpression<T>(this.getMap, newPath, this.castResultValue);
    }
}

