/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentFactory;

public final class Doc {
    private final Map<String, Object> source;
    private final Supplier<String> raw;
    private final int docId;
    private final String index;
    private final String id;
    private final long version;
    private final long seqNo;
    private final long primaryTerm;

    public Doc(int docId, String index, String id, long version, long seqNo, long primaryTerm, Map<String, Object> source, Supplier<String> raw) {
        this.docId = docId;
        this.index = index;
        this.id = id;
        this.version = version;
        this.source = source;
        this.raw = raw;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    public int docId() {
        return this.docId;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getId() {
        return this.id;
    }

    public String getRaw() {
        return this.raw.get();
    }

    public Map<String, Object> getSource() {
        return this.source;
    }

    public String getIndex() {
        return this.index;
    }

    public Doc withUpdatedSource(Map<String, Object> updatedSource) {
        return new Doc(this.docId, this.index, this.id, this.version, this.seqNo, this.primaryTerm, updatedSource, () -> {
            try {
                return Strings.toString(XContentFactory.jsonBuilder().map(updatedSource));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public String toString() {
        return this.source != null ? this.source.toString() : null;
    }
}

