/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.predicate;

import io.crate.data.Input;
import io.crate.expression.predicate.PredicateModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public class NotPredicate
extends Scalar<Boolean, Boolean> {
    public static final String NAME = "op_not";
    public static final Signature SIGNATURE = Signature.scalar("op_not", DataTypes.BOOLEAN.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature());
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(PredicateModule module) {
        module.register(SIGNATURE, NotPredicate::new);
    }

    private NotPredicate(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (symbol != null) : "function must not be null";
        assert (symbol.arguments().size() == 1) : "function's number of arguments must be 1";
        Symbol arg = symbol.arguments().get(0);
        if (arg instanceof Input) {
            Object value = ((Input)((Object)arg)).value();
            if (value == null) {
                return Literal.of(DataTypes.BOOLEAN, null);
            }
            if (value instanceof Boolean) {
                return Literal.of((Boolean)value == false);
            }
        }
        return symbol;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Boolean> ... args) {
        assert (args.length == 1) : "number of args must be 1";
        Boolean value = args[0].value();
        return value != null ? Boolean.valueOf(value == false) : null;
    }
}

