/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.predicate;

import io.crate.expression.predicate.PredicateModule;
import io.crate.metadata.FunctionIdent;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.FunctionInfo;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.index.query.MultiMatchQueryType;

public class MatchPredicate
implements FunctionImplementation {
    public static final String NAME = "match";
    public static final Signature TEXT_MATCH = Signature.scalar("match", DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature());
    public static final Signature GEO_MATCH = Signature.scalar("match", DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.GEO_SHAPE.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature());
    public static final FunctionIdent IDENT = new FunctionIdent(new FunctionName(null, "match"), Arrays.asList(ObjectType.UNTYPED, DataTypes.STRING, DataTypes.STRING, ObjectType.UNTYPED));
    public static final FunctionInfo INFO = new FunctionInfo(IDENT, DataTypes.BOOLEAN, FunctionType.SCALAR, Set.of());
    public static final Set<DataType<?>> SUPPORTED_TYPES = Set.of(DataTypes.STRING, DataTypes.GEO_SHAPE);
    private static final Map<DataType<?>, String> DATA_TYPE_TO_DEFAULT_MATCH_TYPE = Map.of(DataTypes.STRING, MultiMatchQueryType.BEST_FIELDS.toString().toLowerCase(Locale.ENGLISH), DataTypes.GEO_SHAPE, "intersects");
    private static final Set<String> SUPPORTED_GEO_MATCH_TYPES = Set.of("intersects", "disjoint", "within");
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(PredicateModule module) {
        module.register(GEO_MATCH, MatchPredicate::new);
        module.register(TEXT_MATCH, MatchPredicate::new);
    }

    private MatchPredicate(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    private static String defaultMatchType(DataType<?> dataType) {
        String matchType = DATA_TYPE_TO_DEFAULT_MATCH_TYPE.get(dataType);
        if (matchType == null) {
            throw new IllegalArgumentException("No default matchType found for dataType: " + dataType);
        }
        return matchType;
    }

    public static String getMatchType(@Nullable String matchType, DataType<?> columnType) {
        if (matchType == null) {
            return MatchPredicate.defaultMatchType(columnType);
        }
        if (columnType.equals(DataTypes.STRING)) {
            try {
                MultiMatchQueryType.parse(matchType, LoggingDeprecationHandler.INSTANCE);
                return matchType;
            }
            catch (ElasticsearchParseException e) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid MATCH type '%s' for type '%s'", matchType, columnType), e);
            }
        }
        if (columnType.equals(DataTypes.GEO_SHAPE)) {
            if (!SUPPORTED_GEO_MATCH_TYPES.contains(matchType)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid MATCH type '%s' for type '%s', valid types are: [%s]", matchType, columnType, String.join((CharSequence)",", SUPPORTED_GEO_MATCH_TYPES)));
            }
            return matchType;
        }
        throw new IllegalArgumentException("No match type for dataType: " + columnType);
    }
}

