/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.predicate;

import io.crate.data.Input;
import io.crate.expression.predicate.PredicateModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;

public class IsNullPredicate<T>
extends Scalar<Boolean, T> {
    public static final String NAME = "op_isnull";
    public static final Signature SIGNATURE = Signature.scalar("op_isnull", TypeSignature.parseTypeSignature("E"), DataTypes.BOOLEAN.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E"));
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(PredicateModule module) {
        module.register(SIGNATURE, IsNullPredicate::new);
    }

    private IsNullPredicate(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (symbol != null) : "function must not be null";
        assert (symbol.arguments().size() == 1) : "function's number of arguments must be 1";
        Symbol arg = symbol.arguments().get(0);
        if (arg.equals(Literal.NULL)) {
            return Literal.of(true);
        }
        if (arg.symbolType().isValueSymbol()) {
            return Literal.of(((Input)((Object)arg)).value() == null);
        }
        return symbol;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        assert (args.length == 1) : "number of args must be 1";
        return args[0] == null || args[0].value() == null;
    }
}

