/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.any;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.OperatorModule;
import io.crate.expression.operator.any.AnyOperator;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.sql.tree.ComparisonExpression;
import io.crate.types.TypeSignature;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.IntPredicate;

public final class AnyOperators {
    public static final List<String> OPERATOR_NAMES = Lists2.concat(Type.fullQualifiedNames(), List.of("any_like", "any_ilike", "any_not_like", "any_not_ilike"));

    public static void register(OperatorModule module) {
        for (Type type : Type.values()) {
            module.register(Signature.scalar(type.opName, TypeSignature.parseTypeSignature("E"), TypeSignature.parseTypeSignature("array(E)"), Operator.RETURN_TYPE.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), (signature, boundSignature) -> new AnyOperator((Signature)signature, (Signature)boundSignature, type.cmp));
        }
    }

    public static Iterable<?> collectionValueToIterable(Object collectionRef) throws IllegalArgumentException {
        if (collectionRef instanceof Object[]) {
            return Arrays.asList((Object[])collectionRef);
        }
        if (collectionRef instanceof Collection) {
            return (Collection)collectionRef;
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "cannot cast %s to Iterable", collectionRef));
    }

    private AnyOperators() {
    }

    public static enum Type {
        EQ(ComparisonExpression.Type.EQUAL, result -> result == 0),
        NEQ(ComparisonExpression.Type.NOT_EQUAL, result -> result != 0),
        GTE(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, result -> result >= 0),
        GT(ComparisonExpression.Type.GREATER_THAN, result -> result > 0),
        LTE(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, result -> result <= 0),
        LT(ComparisonExpression.Type.LESS_THAN, result -> result < 0);

        final String opName;
        final String opSymbol;
        final IntPredicate cmp;

        private Type(ComparisonExpression.Type type, IntPredicate cmp) {
            this.opName = "any_" + type.getValue();
            this.opSymbol = type.getValue();
            this.cmp = cmp;
        }

        public String opName() {
            return this.opName;
        }

        public static List<String> fullQualifiedNames() {
            return Lists2.map(Arrays.asList(Type.values()), t -> t.opName);
        }

        @VisibleForTesting
        public static List<String> operatorSymbols() {
            return Lists2.map(Arrays.asList(Type.values()), t -> t.opSymbol);
        }
    }
}

