/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.any;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.any.AnyOperators;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import java.util.function.IntPredicate;

public final class AnyOperator
extends Operator<Object> {
    public static final String OPERATOR_PREFIX = "any_";
    private final Signature signature;
    private final Signature boundSignature;
    private final IntPredicate cmpIsMatch;
    private final DataType leftType;

    AnyOperator(Signature signature, Signature boundSignature, IntPredicate cmpIsMatch) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.cmpIsMatch = cmpIsMatch;
        this.leftType = boundSignature.getArgumentDataTypes().get(0);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    private Boolean doEvaluate(Object left, Iterable<?> rightValues) {
        boolean anyNulls = false;
        for (Object rightValue : rightValues) {
            if (rightValue == null) {
                anyNulls = true;
                continue;
            }
            if (!this.cmpIsMatch.test(this.leftType.compare(left, rightValue))) continue;
            return true;
        }
        return anyNulls ? null : Boolean.valueOf(false);
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        assert (args != null) : "args must not be null";
        assert (args.length == 2) : "number of args must be 2";
        assert (args[0] != null) : "1st argument must not be null";
        Object item = args[0].value();
        Object items = args[1].value();
        if (items == null || item == null) {
            return null;
        }
        return this.doEvaluate(item, AnyOperators.collectionValueToIterable(items));
    }
}

