/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.any;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.TriPredicate;
import io.crate.expression.operator.any.AnyOperators;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataType;

public class AnyLikeOperator
extends Operator<Object> {
    private final Signature signature;
    private final Signature boundSignature;
    private final TriPredicate<String, String, Integer> matcher;
    private final int patternMatchingFlags;

    public AnyLikeOperator(Signature signature, Signature boundSignature, TriPredicate<String, String, Integer> matcher, int patternMatchingFlags) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.matcher = matcher;
        this.patternMatchingFlags = patternMatchingFlags;
        DataType innerType = ((ArrayType)boundSignature.getArgumentDataTypes().get(1)).innerType();
        if (innerType.id() == 12) {
            throw new IllegalArgumentException("ANY on object arrays is not supported");
        }
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    private Boolean doEvaluate(Object left, Iterable<?> rightIterable) {
        String pattern = (String)left;
        boolean hasNull = false;
        for (Object elem : rightIterable) {
            if (elem == null) {
                hasNull = true;
                continue;
            }
            assert (elem instanceof String) : "elem must be a String";
            String elemValue = (String)elem;
            if (!this.matcher.test(elemValue, pattern, this.patternMatchingFlags)) continue;
            return true;
        }
        return hasNull ? null : Boolean.valueOf(false);
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        Object value = args[0].value();
        Object collectionReference = args[1].value();
        if (collectionReference == null || value == null) {
            return null;
        }
        return this.doEvaluate(value, AnyOperators.collectionValueToIterable(collectionReference));
    }
}

